/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.util.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.worldgen.RomanNumber;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NameGenerator
extends WorldSavedData {
    private static final String DATA_NAME = "waystones_NameGenerator";
    private static final String TAG_LIST_NAME = "UsedNames";
    private static final String[] random1 = new String[]{"Kr", "Ca", "Ra", "Rei", "Mar", "Luk", "Cro", "Cru", "Ray", "Bre", "Zed", "Mor", "Jag", "Mer", "Jar", "Mad", "Cry", "Zur", "Mjol", "Zork", "Creo", "Azak", "Azur", "Mrok", "Drak"};
    private static final String[] random2 = new String[]{"ir", "mi", "air", "sor", "mee", "clo", "red", "cra", "ark", "arc", "mur", "zer", "miri", "lori", "cres", "zoir", "urak", "marac", "slamar", "salmar"};
    private static final String[] random3 = new String[]{"d", "ed", "es", "er", "ark", "arc", "der", "med", "ure", "zur", "mur", "tron", "cred"};
    private Map<String, String> BIOME_NAMES;
    private final Set<String> usedNames = Sets.newHashSet();

    public NameGenerator() {
        super(DATA_NAME);
    }

    public NameGenerator(String name) {
        super(name);
    }

    private String randomName(Random rand) {
        return random1[rand.nextInt(random1.length)] + random2[rand.nextInt(random2.length)] + random3[rand.nextInt(random3.length)];
    }

    public void init() {
        this.BIOME_NAMES = Maps.newHashMap();
        this.addBiomeName(Biomes.field_150584_S, "Taiga");
        this.addBiomeName(Biomes.field_150578_U, "Taiga");
        this.addBiomeName(Biomes.field_76768_g, "Taiga");
        this.addBiomeName(Biomes.field_76772_c, "Plains");
        this.addBiomeName(Biomes.field_76789_p, "Island");
        this.addBiomeName(Biomes.field_76788_q, "Island");
        this.addBiomeName(Biomes.field_76781_i, "River");
        this.addBiomeName(Biomes.field_76777_m, "River");
        this.addBiomeName(Biomes.field_76787_r, "Beach");
        this.addBiomeName(Biomes.field_150577_O, "Beach");
        this.addBiomeName(Biomes.field_150576_N, "Beach");
        this.addBiomeName(Biomes.field_150583_P, "Forest");
        this.addBiomeName(Biomes.field_150582_Q, "Forest");
        this.addBiomeName(Biomes.field_76785_t, "Forest");
        this.addBiomeName(Biomes.field_76767_f, "Forest");
        this.addBiomeName(Biomes.field_150585_R, "Forest");
        this.addBiomeName(Biomes.field_185444_T, "Forest");
        this.addBiomeName(Biomes.field_185448_Z, "Forest");
        this.addBiomeName(Biomes.field_185429_aa, "Forest");
        this.addBiomeName(Biomes.field_185430_ab, "Forest");
        this.addBiomeName(Biomes.field_150575_M, "Ocean");
        this.addBiomeName(Biomes.field_76771_b, "Ocean");
        this.addBiomeName(Biomes.field_76776_l, "Ocean");
        this.addBiomeName(Biomes.field_76769_d, "Desert");
        this.addBiomeName(Biomes.field_76786_s, "Desert");
        this.addBiomeName(Biomes.field_185442_R, "Desert");
        this.addBiomeName(Biomes.field_150579_T, "Hills");
        this.addBiomeName(Biomes.field_76770_e, "Hills");
        this.addBiomeName(Biomes.field_76783_v, "Hills");
        this.addBiomeName(Biomes.field_150580_W, "Hills");
        this.addBiomeName(Biomes.field_185443_S, "Hills");
        this.addBiomeName(Biomes.field_185434_af, "Hills");
        this.addBiomeName(Biomes.field_150581_V, "Hills");
        this.addBiomeName(Biomes.field_76784_u, "Hills");
        this.addBiomeName(Biomes.field_185433_ae, "Hills");
        this.addBiomeName(Biomes.field_76780_h, "Swamps");
        this.addBiomeName(Biomes.field_150599_m, "Swamps");
        this.addBiomeName(Biomes.field_150588_X, "Savanna");
        this.addBiomeName(Biomes.field_150587_Y, "Plateau");
        this.addBiomeName(Biomes.field_185435_ag, "Savanna");
        this.addBiomeName(Biomes.field_185436_ah, "Savanna");
        this.addBiomeName(Biomes.field_76774_n, "Icelands");
        this.addBiomeName(Biomes.field_76775_o, "Icelands");
        this.addBiomeName(Biomes.field_185445_W, "Icelands");
        this.addBiomeName(Biomes.field_76782_w, "Jungle");
        this.addBiomeName(Biomes.field_150574_L, "Jungle");
        this.addBiomeName(Biomes.field_76792_x, "Jungle");
        this.addBiomeName(Biomes.field_185446_X, "Jungle");
        this.addBiomeName(Biomes.field_185447_Y, "Jungle");
        this.addBiomeName(Biomes.field_150607_aa, "Mesa");
        this.addBiomeName(Biomes.field_150589_Z, "Mesa");
        this.addBiomeName(Biomes.field_150608_ab, "Mesa");
        this.addBiomeName(Biomes.field_185437_ai, "Mesa");
        this.addBiomeName(Biomes.field_185439_ak, "Mesa");
        this.addBiomeName(Biomes.field_185438_aj, "Mesa");
        this.addBiomeName(Biomes.field_185440_P, "Void");
        this.addBiomeName(Biomes.field_76779_k, "Skies");
    }

    private void addBiomeName(Biome biome, String name) {
        this.BIOME_NAMES.put(biome.field_76791_y, name);
    }

    @Deprecated
    public String getName(Biome biome, Random rand) {
        return this.getName(BlockPos.field_177992_a, 0, biome, rand);
    }

    public String getName(BlockPos pos, int dimension, Biome biome, Random rand) {
        if (this.BIOME_NAMES == null) {
            this.init();
        }
        String name = null;
        List<String> customNames = Arrays.asList(WaystoneConfig.worldGen.customNames);
        Collections.shuffle(customNames);
        for (String customName : customNames) {
            if (this.usedNames.contains(customName)) continue;
            name = customName;
            break;
        }
        if (name == null) {
            String biomeSuffix = this.BIOME_NAMES.get(biome.field_76791_y);
            String tryName = name = this.randomName(rand) + (biomeSuffix != null ? " " + biomeSuffix : "");
            int i = 1;
            while (this.usedNames.contains(tryName)) {
                tryName = name + " " + RomanNumber.toRoman(i);
                ++i;
            }
            name = tryName;
        }
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(pos, dimension, name);
        MinecraftForge.EVENT_BUS.post((Event)event);
        name = event.getWaystoneName();
        this.usedNames.add(name);
        this.func_76185_a();
        return name;
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList tagList = compound.func_150295_c(TAG_LIST_NAME, 8);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.usedNames.add(((NBTTagString)tagList.func_179238_g(i)).func_150285_a_());
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (String entry : this.usedNames) {
            tagList.func_74742_a((NBTBase)new NBTTagString(entry));
        }
        compound.func_74782_a(TAG_LIST_NAME, (NBTBase)tagList);
        return compound;
    }

    public static NameGenerator get(World world) {
        MapStorage storage = world.func_175693_T();
        if (storage != null) {
            NameGenerator instance = (NameGenerator)storage.func_75742_a(NameGenerator.class, DATA_NAME);
            if (instance == null) {
                instance = new NameGenerator();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
        return new NameGenerator();
    }
}

